;Rotations 3D grace aux log et exp.
;Intret double: - plus rapide qu'avec des MULS
;                - temps machine fixe... utile pour les fulls.
;
; Code by Elric/Holocaust.

NB_PTS_	=	4

MAIN	CLR.L	-(SP)
	MOVE.W	#$20,-(SP)
	TRAP	#1
	ADDQ.W	#6,SP

	CLR	-(SP)
	PEA	-1.W
	PEA	-1.W
	MOVE	#5,-(SP)
	TRAP	#14
	LEA	12(SP),SP

	MOVE.L	#FIN,$008.W
	MOVE.L	#FIN,$00C.W
	MOVE.L	#FIN,$010.W
	MOVE.L	#FIN,$014.W
	MOVE.L	#FIN,$018.W
	MOVE.L	#FIN,$01C.W
	MOVE.L	#FIN,$020.W

	LEA	DEB_BSS,A0
	LEA	END_BSS,A1
.KILL_IT	CLR.L	(A0)+
	CMP.L	A1,A0
	BLE.S	.KILL_IT

	MOVE.L	#BUFFER,D0
	CLR.B	D0
	MOVE.L	D0,SCREEN1
	ADDI.L	#32000,D0
	MOVE.L	D0,SCREEN2

	MOVE.B	SCREEN1+1,$FFFF8201.W
	MOVE.B	SCREEN1+2,$FFFF8203.W

	BSR	PREPA_LOG_EXP

	CLR.W	Z_BASE

	LEA	SINUS,A0
	LEA	SINUS+LONG_SINUS,A1
	MOVE.W	#(LONG_SINUS/8)-1,D7
.RECOPY	MOVE.W	(A0)+,(A1)+
	DBRA	D7,.RECOPY

	MOVE.W	#$2700,SR
	CLR.B	$FFFFFA07.W
	CLR.B	$FFFFFA09.W
	MOVE.L	#VBLR,$70.W
	CLR.W	NB_VBL
	MOVE.W	#$2300,SR

MAIN_LOOP	BSR	VSYNC
	MOVE	#$011,$FFFF8240.W

	LEA	POINTS,A0
	LEA	ANGLES,A1
	LEA	TRANS,A6
	LEA	BUF_PTS,A2
	BSR	ROTATE

	BSR	EFFAC

	BSR	AFFICH

	BSR	SWAPEC

	MOVE.B	$FFFFFC02.W,D7
	LEA	ANGLES,A0
	MOVE.W	(A0),D0
	ADD	ADX,D0
	CMPI.B	#$1,D7
	BNE.S	.NO_F1
	ADDQ.W	#2,D0
.NO_F1
	CMPI.B	#$2,D7
	BNE.S	.NO_F2
	SUBQ.W	#2,D0
.NO_F2
	ANDI.W	#1023,D0
	MOVE.W	D0,(A0)+
	MOVE.W	(A0),D0
	ADD	ADY,D0
	CMPI.B	#$3,D7
	BNE.S	.NO_F3
	ADDQ.W	#2,D0
.NO_F3
	CMPI.B	#$4,D7
	BNE.S	.NO_F4
	SUBQ.W	#2,D0
.NO_F4
	ANDI.W	#1023,D0
	MOVE.W	D0,(A0)+
	MOVE.W	(A0),D0
	ADD	ADZ,D0
	CMPI.B	#$5,D7
	BNE.S	.NO_F5
	ADDQ.W	#2,D0
.NO_F5
	CMPI.B	#$6,D7
	BNE.S	.NO_F6
	SUBQ.W	#2,D0
.NO_F6
	ANDI.W	#1023,D0
	MOVE.W	D0,(A0)+

	CMPI.B	#7,D7
	BNE.S	.NO7
	ADDQ.W	#1,Z_BASE
.NO7
	CMPI.B	#8,D7
	BNE.S	.NO8
	SUBQ.W	#1,Z_BASE
.NO8
	;MOVE	DONNEE,$FFFFC
	;MOVE	TIME,$FFFFC

	CMPI.B	#$F,$FFFFFC02.W
	BNE.S	.NO_TIME
	ST	$FFFF8240.W
.NO_TIME

	CMPI.B	#$39,$FFFFFC02.W
	BEQ.S	FIN
	BRA	MAIN_LOOP

FIN	MOVE.L	4.W,A0
	JMP	(A0)


VSYNC	CMPI	#1,NB_VBL
	BLT.S	VSYNC
	CLR.W	NB_VBL
	RTS

VBLR	ADDQ.W	#1,NB_VBL
	RTE

SWAPEC	MOVE.L	SCREEN1,D0
	MOVE.L	SCREEN2,SCREEN1
	MOVE.L	D0,SCREEN2

	MOVE.B	SCREEN1+1,$FFFF8201.W
	MOVE.B	SCREEN1+2,$FFFF8203.W
	RTS

EFFAC
	MOVE.L	SCREEN2,A0
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	MOVEQ	#0,D3
	MOVEQ	#0,D4
	MOVEQ	#0,D5
	MOVEQ	#0,D6
	MOVE.L	D0,A1
	MOVE.L	D0,A2
	MOVE.L	D0,A3
	MOVE.L	D0,A4
	MOVE.L	D0,A5
	MOVE.L	D0,A6
	MOVE	#200-1,D7
.EFF	MOVEM.L	D0-D6/A1-A6,(A0)
	MOVEM.L	D0-D6/A1-A6,4*13(A0)
	MOVEM.L	D0-D6/A1-A6,4*13*2(A0)
	MOVE.L	D0,4*13*3(A0)
	LEA	160(A0),A0
	DBF	D7,.EFF
	RTS
	;194    (DONNEE)
EMUL_EFFAC
	MOVE.L	SCREEN2,A0
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	MOVEQ	#0,D3
	MOVEQ	#0,D4
	MOVEQ	#0,D5
	MOVEQ	#0,D6
	MOVE.L	D0,A1
	MOVE.L	D0,A2
	MOVE.L	D0,A3
	MOVE.L	D0,A4
	MOVE.L	D0,A5
	MOVE.L	D0,A6
	MOVE	#200-1,D7
.EFF	MOVEM.L	D0-D6/A1-A6,(A0)
	MOVEM.L	D0-D6/A1-A6,4*13(A0)
	MOVEM.L	D0-D6/A1-A6,4*13*2(A0)
	MOVE.L	D0,4*13*3(A0)
	LEA	0(A0),A0
	DBF	D7,.EFF
	RTS

EFFACE1	RTS
	MOVE.L	SCREEN2,A0
	MOVEQ	#0,D0
	MOVE.W	#200-1,D7
.ALL
N	SET	0
	REPT	20
	MOVE.L	D0,N(A0)
N	SET	N+8
	ENDR
	LEA	160(A0),A0
	DBRA	D7,.ALL
	RTS

AFFICH	LEA	BUF_PTS,A0
	JSR	PROJETTE
	RTS

PROJETTE	LEA	CORES_X,A2
	MOVE.L	SCREEN2,A3
	LEA	COEFF+380*2,A1
	LEA	COORD,A5
	MOVE.W	#NB_PTS_-1,D7
AFF_ALL	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	MOVE.W	(A0)+,D2
	ADD.W	Z_BASE,D2
	ADD.W	D2,D2
	MOVE.W	(A1,D2.W),D2
	MULS.W	D2,D0
	ASR.L	#8,D0
	MULS.W	D2,D1
	ASR.L	#8,D1
MOD_X	ADDI.W	#160,D0
MOD_Y	ADDI.W	#100,D1
	MOVE	D0,(A5)+
	MOVE	D1,(A5)+

	MULS.W	#160,D1
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	2(A2,D0.W),D1
	MOVE.W	(A2,D0.W),D0
	OR.W	D0,(A3,D1.W)

	DBRA	D7,AFF_ALL
	RTS

COORD	DCB	2*NB_PTS_,0

;ENTRES : A0=TABLE DE POINTS ( .W:NB DE POINTS, ET LES POINTS)
;          A1=TABLE D'ANGLE ( ANGLE X, ANGLE Y, ANGLE Z)
;          A6=TABLE DE TRANSLATION ( U_X, U_Y, U_Z)
;          A2=TABLE DE DESTINATION POUR LES POINTS

;Formules de rotation 3 axes:
;X'=X[SIN(T)SIN(U)SIN(V)+COS(T)COS(V)]+Y[COS(T)SIN(U)SIN(V)-SIN(T)COS(V)]+Z[COS(U)SIN(V)]
;Y'=X[SIN(T)COS(U)]+Y[COS(T)COS(U)]-ZSIN(U)
;Z'=X[SIN(T)SIN(U)COS(V)-COS(T)SIN(V)]+Y[COS(T)SIN(U)COS(V)+SIN(T)SIN(V)]+Z[COS(U)COS(V)]
ROTATE	LEA	SINUS(PC),A4	;SINUS
	LEA	LONG_SINUS/4(A4),A3	;COSINUS

	MOVE.W	(A1)+,D0	;ANGLE_X
	ADD.W	D0,D0
	MOVE.W	(A3,D0.W),D1	;COSINUS TETA_X
	MOVE.W	(A4,D0.W),D0	;SINUS TETA_X

	MOVE.W	(A1)+,D2	;ANGLE_Y
	ADD.W	D2,D2
	MOVE.W	(A3,D2.W),D3	;COSINUS TETA_Y
	MOVE.W	(A4,D2.W),D2	;SINUS TETA_Y

	MOVE.W	(A1)+,D4	;ANGLE_Z
	ADD.W	D4,D4
	MOVE.W	(A3,D4.W),D5	;COSINUS TETA_Z
	MOVE.W	(A4,D4.W),D4	;SINUS TETA_Z

	LEA	MATRICE,A4
	LEA	LOGARITHMES+512*2(PC),A3
	;ON FABRIQUE SIN(T)*SIN(U)*SIN(V)+COS(T)*COS(V)
	MOVE.W	D0,D6	;D6=SIN(T)
	MULS.W	D2,D6	;D6=SIN(T)*SIN(U)
	ASR.L	#8,D6
	MULS.W	D4,D6	;D6=SIN(T)*SIN(U)*SIN(V)
	MOVE.W	D1,D7	;D7=COS(T)
	MULS.W	D5,D7	;D7=COS(T)*COS(V)
	ADD.L	D7,D6
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK1
	MOVEQ	#1*2,D6
.OK1	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE COS(T)*SIN(U)*SIN(V)-SIN(T)*COS(V)
	MOVE.W	D1,D6	;D6=COS(T)
	MULS.W	D2,D6	;D6=COS(T)*SIN(U)
	ASR.L	#8,D6
	MULS.W	D4,D6	;D6=COS(T)*SIN(U)*SIN(V)
	MOVE.W	D0,D7	;D7=SIN(T)
	MULS.W	D5,D7	;D7=SIN(T)*COS(V)
	SUB.L	D7,D6
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK2
	MOVEQ	#1*2,D6
.OK2	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE COS(U)*SIN(V)
	MOVE.W	D3,D6	;D6=COS(U)
	MULS.W	D4,D6	;D6=COS(U)*SIN(V)
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK3
	MOVEQ	#1*2,D6
.OK3	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE SIN(T)*COS(U)
	MOVE.W	D0,D6	;D6=SIN(T)
	MULS.W	D3,D6	;D6=SIN(T)*COS(U)
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK4
	MOVEQ	#1*2,D6
.OK4	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE COS(T)*COS(U)
	MOVE.W	D1,D6	;D6=COS(T)
	MULS.W	D3,D6	;D6=COS(T)*COS(U)
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK5
	MOVEQ	#1*2,D6
.OK5	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE -SIN(U)
	MOVE.W	D2,D6
	NEG.W	D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK6
	MOVEQ	#1*2,D6
.OK6	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE SIN(T)*SIN(U)*COS(V)-COS(T)*SIN(V)
	MOVE.W	D0,D6	;D6=SIN(T)
	MULS.W	D2,D6	;D6=SIN(T)*SIN(U)
	ASR.L	#8,D6
	MULS.W	D5,D6	;D6=SIN(T)*SIN(U)*COS(V)
	MOVE.W	D1,D7	;D7=COS(T)
	MULS.W	D4,D7	;D7=COS(T)*SIN(V)
	SUB.L	D7,D6
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK7
	MOVEQ	#1*2,D6
.OK7	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE COS(T)*SIN(U)*COS(V)+SIN(T)*SIN(V)
	MOVE.W	D1,D6	;D6=COS(T)
	MULS.W	D2,D6	;D6=COS(T)*SIN(U)
	ASR.L	#8,D6
	MULS.W	D5,D6	;D6=COS(T)*SIN(U)*COS(V)
	MOVE.W	D0,D7	;D7=SIN(T)
	MULS.W	D4,D7	;D7=SIN(T)*SIN(V)
	ADD.L	D7,D6
	ASR.L	#8,D6
	ADD.W	D6,D6
	TST.W	D6
	BNE.S	.OK8
	MOVEQ	#1*2,D6
.OK8	MOVE.W	(A3,D6.W),(A4)+

	;ON FABRIQUE COS(U)*COS(V)
	MULS.W	D3,D5	;D5=COS(U)*COS(V)
	ASR.L	#8,D5
	ADD.W	D5,D5
	TST.W	D5
	BNE.S	.OK9
	MOVEQ	#1*2,D5
.OK9	MOVE.W	(A3,D5.W),(A4)+

	MOVE.W	(A6)+,D0
	ADD.W	D0,D0	;U_X*2
	MOVE.W	D0,TRANSLATE_X
	MOVE.W	(A6)+,D0
	ADD.W	D0,D0	;U_Y*2
	MOVE.W	D0,TRANSLATE_Y
	MOVE.W	(A6),D0
	ADD.W	D0,D0	;U_Z*2
	MOVE.W	D0,TRANSLATE_Z

	MOVE.W	(A0)+,D7	;D7=NB DE POINTS
	SUBQ.W	#1,D7
	MOVE.L	#MATRICE,D6
	LEA	BUF_EXP,A5

ROTATE_ALL	MOVE.L	D6,A4
	MOVE.W	(A0)+,D0	;X*2
TRANSLATE_X = *+2
	ADDI.W	#$1234,D0
	MOVE.W	(A0)+,D1	;Y*2
TRANSLATE_Y = *+2
	ADDI.W	#$1234,D1
	MOVE.W	(A0)+,D2	;Z*2
TRANSLATE_Z = *+2
	ADDI.W	#$1234,D2

	REPT	3
	MOVE.W	(A3,D0.W),D3	;LOG(X)
	ADD.W	(A4)+,D3	;LOG(X)+LOG(COEFF)
	MOVE.W	(A5,D3.W),D3	;D3=X*COEFF
	MOVE.W	(A3,D1.W),D4	;LOG(Y)
	ADD.W	(A4)+,D4	;LOG(Y)+LOG(COEFF)
	MOVE.W	(A5,D4.W),D4	;D4=Y*COEFF
	MOVE.W	(A3,D2.W),D5	;LOG(Z)
	ADD.W	(A4)+,D5	;LOG(Z)+LOG(COEFF)
	MOVE.W	(A5,D5.W),D5	;D5=Z*COEFF
	ADD.W	D4,D3
	ADD.W	D5,D3
	MOVE.W	D3,(A2)+
	ENDR

	DBRA	D7,ROTATE_ALL
	RTS

PREPA_LOG_EXP	;ON ARRANGE LA PARTIE NEGATIVE DE LA TABLE DES LOG.
	LEA	LOGARITHMES(PC),A0
	MOVE.W	#512-1,D7
LOG_NEGATIFS	MOVE.W	(A0),D0
	ADD.W	D0,D0
	ADDI.W	#LONG_EXP/2,D0
	MOVE.W	D0,(A0)+
	DBRA	D7,LOG_NEGATIFS
	MOVE.W	#LONG_EXP/2,D7
	MULU.W	#3,D7
	MOVE.W	D7,(A0)+	;D7=LONG_EXP*3 (ZERO)
	MOVE.W	#512-1,D7
LOG_POSITIFS	MOVE.W	(A0),D0
	ADD.W	D0,D0
	MOVE.W	D0,(A0)+	;LOG*2
	DBRA	D7,LOG_POSITIFS

;ON CREE LA PARTIE NEGATIVE ET LA 2EME PARTIE POSITIVE DES EXPONENTIELLES.
	LEA	EXPONENTIELLES(PC),A0
	LEA	BUF_EXP,A1
	LEA	LONG_EXP/2(A1),A2
	LEA	LONG_EXP/2(A2),A3
	MOVE.W	#LONG_EXP/4-1,D7
MAKE_EXP	MOVEQ	#0,D0
	MOVE.L	(A0)+,D0
	LSR.L	#8,D0	;VALEUR REELLE DU RESULTAT
	MOVE.W	D0,(A1)+
	MOVE.W	D0,(A3)+
	NEG.W	D0
	MOVE.W	D0,(A2)+
	DBRA	D7,MAKE_EXP

;ON CREE LES 2 TABLES DE ZERO LONGUES CHACUNES DE LONG_EXP.
	LEA	BUF_EXP+(LONG_EXP/2)*3,A0
	MOVE.W	#(LONG_EXP/4)*2-1,D7
MAKE_ZERO_TABLE	CLR.W	(A0)+
	DBRA	D7,MAKE_ZERO_TABLE
	RTS

SINUS	INCBIN	SINUSROT.DAT
LONG_SINUS = *-SINUS
	DCB.W	LONG_SINUS/4,0

LOGARITHMES	INCBIN	LOG512.LOG

EXPONENTIELLES	INCBIN	EXP512.EXP
LONG_EXP = *-EXPONENTIELLES

COEFF	INCBIN	COEFF2.3D

	DCB.W	500,0
N	SET	0
CORES_X	REPT	20
	DC.W	32768,N,16384,N,8192,N,4096,N,2048,N,1024,N,512,N,256,N,128,N,64,N,32,N,16,N,8,N,4,N,2,N,1,N
N	SET	N+8
	ENDR
	DCB.W	500,0

ADX	DC	2	Z
ADY	DC	0	X
ADZ	DC	0	Y

POINTS
N	SET	2*20
	DC	4
	DC	-N,N,0
	DC	-N,-N,0
	DC	N,-N,0
	DC	N,N,0

ANGLES	DC.W	0,0,0
TRANS	DC.W	0,0,0

	SECTION	BSS
;BSS gnrale
DEB_BSS
	DS.B	256
BUFFER	DS.B	32000*2
SCREEN1	DS.L	1
SCREEN2	DS.L	1
Z_BASE	DS.W	1
;Calcul des points
MATRICE	DS.W	9
BUF_EXP	DS.W	(LONG_EXP/4)*5
NB_VBL	DS.W	1
BUF_PTS	DS.W	20*3
END_BSS